package com.icetech.cloudcenter.domain.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.icetech.cloudcenter.domain.order.CustomerDoubleSerialize;
import lombok.Data;

import java.io.Serializable;

/**
 * 月卡报表统计
 * @author zys
 */
@Data
public class MonthReportDto implements Serializable {
    /**
     * 新增月卡数
     */
    private Integer addMonthCount;
    /**
     * 新增月卡数收入
     */
    @JsonSerialize(using = CustomerDoubleSerialize.class)
    private double addMonthMoney;
    /**
     * 续费月卡数
     */
    private Integer renewMonthCount;
    /**
     * 续费月卡数收入
     */
    @JsonSerialize(using = CustomerDoubleSerialize.class)
    private double renewMonthMoney;
    /**
     * 总收入（月卡）
     */
    @JsonSerialize(using = CustomerDoubleSerialize.class)
    private double monthTotalCount;
    /**
     * 退费金额
     */
    @JsonSerialize(using = CustomerDoubleSerialize.class)
    private double refundMoney;

}
