package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author kate
 */
@Data
public class InvoiceDetailResponse implements Serializable {
    /**
     * 订单id
     */
    private String orderId;
    /**
     * 交易流水多个用，隔开
     */
    private String tradeNo;
    /**
     * 发票类型
     */
    private Integer buyerTitleType;
    /**
     * 税号
     */
    private String buyerTaxcode;
    /**
     * 发票抬头
     */
    private String buyerTitle;
    /**
     * 商品名称
     */
    private String productName;
    /**
     * 发票金额
     */
    private String amount;
    /**
     * 申请时间
     */
    private Date applyTime;
    /**
     * 备注
     */
    private String remark;
    /**
     * 车场ID
     */
    private Long parkId;
    /**
     * 多个车牌号，中间用逗号隔开
     */
    private String plateNums;
    /**
     * 开票来源同bizType的值
     */
    private Integer source;

    /**
     * 银行名称
     */
    private String bankName;
    /**
     * 银行账号
     */
    private String bankAccount;
    /**
     * 购买方地址
     */
    private String buyerAddress;
    /**
     * 购买方电话
     */
    private String buyerPhone;
    /** 发票备注 */
    private String invoiceRemark;
}
