package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 出场车辆信息
 * @author wangzw
 */
@Data
public class ExitCarInfoResponse extends EnexCarInfoBaseResponse implements Serializable {
    /**
     * 入场车牌
     */
    private String enterNum;

    /**
     * 出场车牌
     */
    private String exitNum;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 车型
     */
    private Integer carType;

    /**
     * 车辆类型
     */
    private Integer type;

    /**
     * 出场图片
     */
    private String imgUrl;
    private String imgPath;

    /**
     * 入场时间
     */
    private Date enterTime;

    /**
     * 出场时间
     */
    private Date exitTime;
    /**
     * 本地订单号
     */
    private String localOrderNum;
    /**
     * 无入场记录标识
     */
    private Integer noneEnterFlag;
}
