package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class ExitCarDto implements Serializable {
    /**
     * 出场记录id
     */
    private Long id;
    private String orderNo;
    /**
     * 入场时间
     */
    private Date enterTime;
    /**
     * 离场时间
     */
    private Date exitTime;
    /**
     * 停车时长单位为秒
     */
    private Long parkTime;
    /**
     * 车牌号
     */
    private String plateNumber;
    /**
     * 车辆类型
     */
    private int type;
    /**
     * 车型
     */
    private int carType;
    /**
     * 总应收
     */
    private String totalPrice;
    /**
     * 总实收
     */
    private String paidPrice;
    /**
     * 总优惠
     */
    private String discountPrice;
    /**
     * 入场图片
     */
    private String enterImg;
    /**
     * 离场图片
     */
    private String exitImg;
    /**
     * 车场名称
     */
    private String parkName;
    /**
     * 操作员
     */
    private String operAccouont;
    /**
     * 停车时长，X小时X分钟X秒
     */
    private String parkTimeStr;

    /**
     * 入口名称
     */
    private String enterName;
    /**
     * 出口名称
     */
    private String exitName;
    /**
     * 异常原因 为字典表id
     */
    private Integer oddStatus;
    private Integer hasSon;
    /**
     * 出场方式：1车牌识别，2遥控器抬杆，3无牌车扫码，4软件人工，5断电应急
     */
    private Integer exitWay;
    private Integer enterWay;

    /**
     * 软件人工入场的操作人账号
     */
    private String enterOperAccount;
    /**
     * 软件人工离场的操作人账号
     */
    private String exitOperAccount;

    /**
     * 入场终端，1 云坐席、2 车场帮APP 、3 云岗亭、4岗亭计费软件、5 车场监控'
     */
    private Integer enterTerminal;

    /**
     * 离场终端，1 云坐席、2 车场帮APP 、3 云岗亭、4岗亭计费软件、5 车场监控'
     */
    private Integer exitTerminal;

    /**
     * 订单标签，1-疑似逃费，2 - 补缴订单, 3-使用上次入场
     */
    private List<Integer> orderTag;

    /**
     * 上次订单号
     */
    private String matchOrderNum;

    /**
     * 无入场记录标识(0=否;1=是)
     */
    private Integer noneEnterFlag;
    /**
     * 入场备注
     */
    private String enterRemark;
    /**
     * 离场备注
     */
    private String exitRemark;
}
