package com.icetech.cloudcenter.domain.response;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 业务数据批量下发进度查询的响应
 * @author fangct
 */
@Data
public class BatchSendProgressResponse implements Serializable {

    private Integer isFinish = 0;
    private List<Progress> progressList;

    @Data
    public static class Progress implements Serializable{

        private String subTaskId;
        private Integer status;
        private Integer serviceType;
        private Long channelId;
        private String channelName;
        private String sn;
        private Integer successRatio;
        private Integer totalNum;
        private Integer successNum;
        private Integer failNum;
        private String reason;
    }

}
