package com.icetech.cloudcenter.domain.request.pnc;

import lombok.Data;

@Data
public class VipCarInfoRequest {
    public static final String PLATE_NUM_DELIMITER = "/";
    public static final String DATE_PATTERN = "yyyy-MM-dd";

    /**
     * 操作类型1=添加 2=修改 3=删除
     */
    protected Integer operType;
    /**
     * 操作时间（unix时间戳）
     */
    protected Long operTime;
    /**
     * VIP车辆类型ID
     */
    protected Integer vipCarTypeId;
    /**
     * VIP车辆类型名称
     */
    protected String vipCarTypeName;
    /**
     * VIP信息表ID
     */
    protected Integer vipInfoId;
    /**
     * 有效期开始日期，格式为yyyy-MM-dd
     */
    protected String startDate;
    /**
     * 有效期结束日期，格式为yyyy-MM-dd
     */
    protected String endDate;
    /**
     * 车主姓名
     */
    protected String owner;
    /**
     * 车主电话
     */
    protected String phone;
    /**
     * 车牌号,可以多个。会以"/"连接。比如车牌号信息：京JS7680/京JS7681/京JS7682/京JS7683/京JS7684/京JS7685
     */
    protected String plateNums;
}
