package com.icetech.cloudcenter.domain.request.pnc;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 无牌车离场请求参数
 * @author fangct
 */
@Setter
@Getter
@ToString
public class PncNoplateExitRequest implements Serializable {
    @NotNull
    private String parkCode;
    @NotNull
    private String channelId;
    @NotNull
    private String plateNum;
    @NotNull
    private Long exitTime;
    @NotNull
    private String orderId;
    private Integer carType;
    private String carDesc;

    private Integer inoutEvent;
    private Integer exTerminal;
    private String operAccount;

    private PaidInfo paidInfo;

    @Setter
    @Getter
    @ToString
    public static class PaidInfo implements Serializable {
        @NotNull
        private String orderId;
        @NotNull
        private String tradeNo;
        @NotNull
        private String totalPrice;
        @NotNull
        private String paidPrice;
        @NotNull
        private String discountPrice;
        @NotNull
        private Integer payWay;
        @NotNull
        private Long payTime;
    }
}
