package com.icetech.cloudcenter.domain.request.pnc;

import java.util.List;

import lombok.Data;

@Data
public class ParkingFacilitiesUpRequest {
    /**
     * 区域编号
     */
    protected String regionCode;
    /**
     * 区域名称
     */
    protected String regionName;
    /**
     * 泊位总数
     */
    protected Integer regionTotalPark;
    /**
     * 空车位数
     */
    protected Integer freeSpace;
    /**
     * 新能源车计费区分纯电和油电混合标识，0是不区分 1是区分，默认是0
     */
    protected Integer isNewEnergyDiffBill;
    /**
     * 是否有内区域类型 1：是 2：否
     */
    protected Integer isSonRegion;
    /**
     * 区域类型 0:顶级 1：非顶级
     */
    protected Integer regionType;
    /**
     * 父级区域编号,当regionType=1时候，必传
     */
    protected String parentCode;
    /**
     * 蓝牌车计费规则编号
     */
    protected String blueCarBill;
    /**
     * isnewEnergyDiffBill是0表示新能源车计费规则编号;isnewEnergyDiffBill是1表示新能源车油电混合车辆的计费规则编号
     */
    protected String newEnergyCarBill;
    /**
     * isnewEnergyDiffBill是0不传此字段;isnewEnergyDiffBill是1表示新能源车纯电车辆的计费规则编号
     */
    protected String newEnergyPureEleCarBill;
    /**
     * 收费月卡车计费规则编号
     */
    protected String fixedCarBill;
    /**
     * 黄牌车计费规则编号
     */
    protected String yellowCarBill;
    /**
     * 区域默认计费规则
     */
    protected String defaultBill;
    /**
     * 储值卡车辆计费规则
     */
    protected String storedCardBill;

    /**
     * 在车位满的情况下，是否禁止临时车入内，0：否 1：是
     */
    private Integer isFullForbidEnter;
    /**
     * 在车位满的情况下，是否禁止月车入内，0：否 1：是
     */
    private Integer isFullForbidMonthEnter;
    /**
     * 在车位满的情况下，是否禁止vip车入内，0：否 1：是
     */
    private Integer isFullForbidVIPEnter;
    /**
     * vip类型ID, 多个以逗号隔开
     */
    private String vipCarType;
    /**
     * 在车位满的情况下，是否禁止预约车入内，0：否 1：是
     */
    private Integer isFullForbidReservEnter;
    /**
     * 在车位满的情况下，是否禁止储值卡车入内，0：否 1：是
     */
    private Integer isFullForbidStoreEnter;
    /**
     * 在车位满的情况下，是否禁止黑名单车入内，0：否 1：是
     */
    private Integer isFullForbidBlackEnter;
    /**
     * 剩余多少空车位时，禁止入场，is_full_ forbidenter为1时不能为空
     */
    private Integer fullEmptyNum;
    /**
     * 此区域中通道信息详情数组
     */
    protected List<ChannelInfo> wayInfo;

    @Data
    public static class ChannelInfo {
        /**
         * 通道编号
         */
        protected String inandoutCode;
        /**
         * 是否是主通道 1=是 0=否
         */
        protected Integer isMaster;
        /**
         * 是否收费  1=是 0=否
         */
        protected Integer isCharge;
        /**
         * 通道名称
         */
        protected String inandoutName;
        /**
         * 通道类型，1入口 2出口
         */
        protected Integer inandoutType;
        /**
         * 是否允许临时车进出 0:不允许  1：允许
         */
        protected Integer isAllowTempcarrun;
        /**
         * 是否允许无牌车扫码进出 0:不允许  1：允许
         */
        protected Integer isAllowNocardrun;
        /**
         * 黄牌车是否允许进 0:不开启  1：开启
         */
        protected Integer isAllowYellowcarrun;
        /**
         * 是否开启模糊识别 0:不开启  1：开启
         */
        protected Integer isOpenVaguetype;
        /**
         * 模糊模式 0：去汉字 1：去汉字1位 2：去汉字2位
         */
        protected Integer vagueType;
        /**
         * 是否开启二维码扫码进出0：不允许，1：允许（删除）
         */
        protected Integer isOpenQrcodetype;
        /**
         * 是否允许新能源车辆进出 0：不允许 1：允许
         */
        protected Integer isAllowNewenergycarrun;
        /**
         * 是否允许预约车进出0：不允许，1：允许
         */
        protected Integer isAllowVisitCar;
        /**
         * 是否允月卡车车进出0：不允许，1：允许
         */
        protected Integer isAllowMonthCar;
        /**
         * 是否允许过期月卡车进出0：不允许，1：允许
         */
        protected Integer isOverTimeMonth;
        /**
         * 过期天数 isOverTimeMonth=1必填
         */
        protected Integer overTimeDay;
        /**
         * 过期卡是否按月卡处理0：否，1：是 isOverTimeMonth=1必填
         */
        protected Integer overTimeMonthlyCard;
        /**
         * 是否允许多位多车月卡车进出1=是 0=否
         */
        protected Integer isAllowABcar;
        /**
         * 是否允许黑名单车进出0：不允许，1：允许
         */
        protected Integer isAllowBackCar;
        /**
         * 是否允许储值卡车进出0：不允许，1：允许
         */
        protected Integer isAllowStoredCar;
        /**
         * 是否允许储值卡车进入 0:不允许  1：允许
         */
        protected Integer isAllowBluerun;
        /**
         * 是否允许Vip车进出0：不允许，1：允许
         */
        protected Integer isVipCar;
        /**
         * 多个以逗号隔开
         */
        protected String vipCarType;
        /**
         * 设备信息
         */
        protected List<DeviceInfo> devices;


        protected String regionCode;    // 非请求字段
    }

    @Data
    public static class DeviceInfo {
        /**
         * 设备编号
         */
        protected String deviceCode;
        /**
         * 设备类型 1：摄像头 2:道闸 3:显示屏  5:机器人
         */
        protected Integer type;
        /**
         * 相机序列号
         */
        protected String serialNumber;
        /**
         * 是否双摄相机，1：是，0：否 type=1时必填
         */
        protected Integer dualCamera;
        /**
         * 是否主相机，0：否，1：是，一个通道只会有一个主相机
         */
        protected Integer isMaster;
        /**
         * 相机ip 所属摄像机的ip
         */
        protected String ip;
        /**
         * 端口 当type=5时候必填
         */
        protected Integer port;


        protected String inandoutCode;    // 非请求字段
    }
}
