package com.icetech.cloudcenter.domain.request.pnc;

import lombok.Data;

@Data
public class ParkConfigUpRequest {
    /**
     * 车场名称
     */
    protected String parkName;
    /**
     * 泊位总数
     */
    protected Integer totalPark;
    /**
     * 空车位数
     */
    protected Integer freePark;
    /**
     * 是否场中场（1：是，2：否）
     */
    protected Integer isMidfield;
    /**
     * 场中场切换免费时长 分钟
     */
    protected Integer switchFreeTime;
    /**
     * 免费时长是否计入停车费用1：是 2
     */
    protected Integer freeTimeStatus;
    /**
     * 计费精度 0：分钟，1：秒
     */
    protected Integer bilPrecision;
    /**
     * 是否补时 1是2否
     */
    protected Integer isFillTime;
    /**
     * 是否抹零头1是2否
     */
    protected Integer isRounding;
    /**
     * 缴费后离场预留免费时长(单位分钟)
     */
    protected Integer freeTimeAfterPay;
    /**
     * 超时计费起始时间1末次缴费时间 2车辆入场时间
     */
    protected Integer overTimeBillType;
    /**
     * 是否允许二次使用免费时长 1不允许2允许
     */
    protected Integer isAllowFreeTmonce;
    /**
     * 出场查无入场记录、支持固定收费1是2否
     */
    protected Integer isFixedFee;
    /**
     * 小型车固定收费金额 单位元 isFixedFee=1时候必填
     */
    protected Integer fixedFeeValue;
    /**
     * 大型车固定收费金额 单位元 isFixedFee=1时候必填
     */
    protected Integer fixedFeeValueBig;
    /**
     * 计费版本1：标准版 ，2：YC
     */
    protected Integer billVersion;
    /**
     * 是否支持电子支付 0：不支持 1：支持
     */
    protected Integer isEpayMent;
    /**
     * 是否支持无感支付 0：不支持 1支持
     */
    protected Integer isNosenPayMent;
    /**
     * 货币单位
     */
    protected String monetaryUnit;
    /**
     * 免费时间内是否自动抬杆 0：不自动  1：自动
     */
    protected Integer isReleaseFreetm;
    /**
     * 军警车是否免费停车 0：不免费 1：免费
     */
    protected Integer isFreeSpecialCar;
    /**
     * 在车位满的情况下，是否禁止临时车入内，0：否 1：是
     */
    protected Integer isFullForbidEnter;
    /**
     * 在车位满的情况下，是否禁止月卡车入内，0：否 1：是
     */
    protected Integer isFullForbidMonthEnter;
    /**
     * 在车位满的情况下，是否禁止vip车入内，0：否 1：是
     */
    protected Integer isFullForbidVIPEnter;
    /**
     * VIP类型ID, 多个以逗号隔开
     */
    protected String vipCarTypeId;
    /**
     * 在车位满的情况下，是否禁止预约车入内，0：否 1：是
     */
    protected Integer isFullForbidReservEnter;
    /**
     * 在车位满的情况下，是否禁止储值卡车入内，0：否 1：是
     */
    protected Integer isFullForbidStoreEnter;
    /**
     * 在车位满的情况下，是否禁止黑名单车入内，0：否 1：是
     */
    protected Integer isFullForbidBlackEnter;
    /**
     * 剩余多少空车位时，禁止入场<br/>
     * {@link #isFullForbidEnter}、{@link #isFullForbidMonthEnter}、{@link #isFullForbidVIPEnter}、{@link #isFullForbidReservEnter}、{@link #isFullForbidStoreEnter}或{@link #isFullForbidBlackEnter}为1时不能为空
     */
    protected Integer fullEmptyNum;
    /**
     * 月卡车是否计入总车位数1是 2 否
     */
    protected Integer isCarDcount;
    /**
     * 访客车辆是否收费 0否 1是
     */
    protected Integer visitIscharge;
    /**
     * 是否支持多位多车管理0：否 1：是
     */
    protected Integer isMultipleVehicles;
    /**
     * 多位多车场内切换时间
     */
    protected Integer multipleTime;
    /**
     * 多位多车收费方式1：超时场内切换，B车收取入场时间至A车出场期间的费用，2：超时场内切换，B车收取从入场到离场的全部费用
     */
    protected Integer multipleBillType;
    /**
     * 双摄相机延时等待时长(毫秒),区间100-5000
     */
    protected Integer dualCameraTime;
    /**
     * 屏显类型1：LED，2：LCD
     */
    protected Integer screenType;
    /**
     * 控制卡型号  1：单屏 2：双屏18：方控 19：科发 27：瑞泰科
     */
    protected Integer ctrlCardModel;
    /**
     * 是否有TTS 1：有，2：没有
     */
    protected Integer isSupportTTS;
    /**
     * 是否进/出共用一个通道1：是，2：否
     */
    protected Integer isInOutPass;
    /**
     * 入场到出场最小时间（秒）当isInOutPass=1必传
     */
    protected Integer enexMinTime;
    /**
     * 出场到入场最小时间（秒）当isInOutPass=1必传
     */
    protected Integer exenMinTime;
    /**
     * 省份简称
     */
    protected String provinceName;
    /**
     * 无牌车扫码校验：0：关闭，1：开启，默认1
     */
    protected Integer isNocardCheck;
    /**
     * 全免车辆重复入场，0：不允许，1：允许，默认为1
     */
    protected Integer freeCarReenter;
    /**
     * 空车位计算方式(1-进出场加减;2-泊位总数减在场车辆)
     */
    protected Integer calcSpaceMethod;
    /**
     * 开启车牌号过滤，1 车场 2 通道
     */
    protected Integer plateFilterType;
    /**
     * 过滤时间，单位秒
     */
    protected Integer filterTime;
    /**
     * 是否允许过期月卡车进出0：不允许，1：允许
     */
    protected Integer isOverTimeMonth;
    /**
     * 月卡过期天数 isOverTimeMonth=1必填
     */
    protected Integer overTimeDay;
    /**
     * 过期expireMcDays天按月卡处理0：否，1：是
     */
    protected Integer overTimeMonthlyCard;
    /**
     * 过期X天按月卡处理，overTimeMonthlyCard为是时必填
     */
    protected Integer expireMcDays;
}
