package com.icetech.cloudcenter.domain.request.pnc;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

@Data
public class ChargeRuleUpRequest {
    /** 计费规则类型，1、通用自然天  2、白天夜间收费 3、24小时计费；  */
    protected Integer billtype;
    /** 是否默认计费规则，0：否，1：是 */
    protected Integer isDefault;
    /** 计费规则编号 时间+随机数小于16位 */
    protected String billtypecode;
    /** 计费规则名称 */
    protected String billtypename;
    /** 计费规则明细 */
    protected JSONObject chargeRule;

    @Data
    public static class NaturalDayInfo {
        /** 免费时长（分钟） */
        protected Integer freetime;
        /** 累计24小时免费时长是否使用多次 （1：24小时免费时长可用一次，2：每次进场都可用 ，默认2） */
        protected Integer isFreetimeOnce;
        /** 是否使用一天最大收费限额(一天) 0：禁用  1：启用 默认为0 */
        protected Integer daynightmaxfeeusing;
        /** 最大收费限额类型1=单天单次最高收费 2=单天最高收费 3=24小时最高收费 */
        protected Integer daynightmaxfeetype;
        /** 24小时统计方式 1=以24小时内的订单入场时间为准 2=以24小时之内的出场时间判断 */
        protected Integer daynightmaxfeecounttype;
        /** 小型车单天最高收费金额，单位元 */
        protected Float daynightmaxfee;
        /** 大型车单天最高收费金额，单位元 */
        protected Float daynightmaxfeeBig;
        /** 是否区分工作日非工作日计费， 1：是 2：否，默认为2 */
        protected Integer isspecialdaycharge;
        /** 通用计费方式或工作日计费方式，1：按次计费 2：按停车时长计费，不区分时工作日非工作日时，此为通用计费配置，区分时，此为工作日计费方式； */
        protected Integer oneBillmethod;
        /** 非工作日计费方式，1：按次计费 2：按停车时长计费 */
        protected Integer twoBillmethod;
        /** 是否区分大小型车计费（0：否，1：是） */
        protected Integer isSmallbigcarSet;
        /** 不区分时，此为通用计费配置，区分时，此为工作日计费配置，请根据计费方式，查看具体的参数说明； */
        protected JSONObject firstConfig;
        /** 非工作日计费配置，不区分工作日非工作日时，该参数不传；请根据计费方式，查看具体的参数说明； */
        protected JSONObject twoConfig;
    }

    @Data
    public static class DayNightInfo {
        /** 免费时长（分钟） */
        protected Integer freetime;
        /** 累计24小时免费时长是否使用多次 （1：24小时免费时长可用一次，2：每次进场都可用 ，默认2） */
        protected Integer isFreetimeOnce;
        /** 是否使用一天最大收费限额(一天) 0：禁用  1：启用 默认为0 */
        protected Integer daynightmaxfeeusing;
        /** 最大收费限额类型1=单天单次最高收费 2=单天最高收费 3=24小时最高收费 */
        protected Integer daynightmaxfeetype;
        /** 24小时统计方式 1=以24小时内的订单入场时间为准 2=以24小时之内的出场时间判断 */
        protected Integer daynightmaxfeecounttype;
        /** 小型车单天最高收费金额，单位元 */
        protected Float daynightmaxfee;
        /** 大型车单天最高收费金额，单位元 */
        protected Float daynightmaxfeeBig;
        /** 白天开始计费时间，0点到开始时间的分钟数；例如早上8点钟为8 * 60 = 480； */
        protected Integer daybegin;
        /** 晚上开始计费时间，0点到开始时间的分钟数；例如晚上8点钟为20 * 60 = 1200； */
        protected Integer nightbegin;
        /** 是否启用白天最大收费， 1：是 2：否, 默认为2 */
        protected Integer daymaxfeeusing;
        /** 小型车白天最大收费金额，单位元 */
        protected Float daymaxfee;
        /** 大型车白天最大收费金额，单位元 */
        protected Float daymaxfeeBig;
        /** 是否启用夜间最大收费， 1：是， 2：否 ，默认为2 */
        protected Integer nightmaxfeeusing;
        /** 小型车夜间最大收费金额，单位元 */
        protected Float nightmaxfee;
        /** 大型车夜间最大收费金额，单位元 */
        protected Float nightmaxfeeBig;
        /** 白天计费方式，1：按次计费 2：按停车时长计费 */
        protected Integer dayBillmethod;
        /** 夜间计费方式，1：按次计费 2：按停车时长计费 */
        protected Integer nightBillmethod;
        /** 是否区分大小型车计费（0：否，1：是） */
        protected Integer isSmallbigcarSet;
        /** 白天计费配置，请根据计费方式，查看具体的参数说明； */
        protected JSONObject dayConfig;
        /** 夜间计费配置，请根据计费方式，查看具体的参数说明； */
        protected JSONObject nightConfig;
    }

    @Data
    public static class OnceInfo {
        /** 是否开启“每次收费”开关，1：是，2：否 ， 默认为1 */
        protected Integer isopenoncecharge;
        /** 小型车每次收费金额，单位元 */
        protected Float oncechargefee;
        /** 大型车每次收费金额，单位元 */
        protected Float oncechargefeeBig;
        /** 是否开启“按分钟收费”开关， 1：是， 2：否， 默认2 */
        protected Integer isopenother2;
        /** 多少分钟范围，单位分钟 */
        protected Integer timeFrame;
        /** 小型车多少分钟范围计费多少钱，单位元 */
        protected Float timeFrameOncefee;
        /** 大型车多少分钟范围计费多少钱，单位元 */
        protected Float timeFrameOncefeeBig;
        /** 小型车超时多少分钟范围每次收费多少钱，单位元 */
        protected Float otherTimeframeOncefee;
        /** 大型车超时多少分钟范围每次收费多少钱，单位元 */
        protected Float otherTimeframeOncefeeBig;
        /** 是否有附加选择项，1：是，2：否，默认为2 */
        protected Integer isattachoption;
        /** 附加选择超过分钟数 */
        protected Integer overTime;
        /** 小型车加收过夜费，单位元 */
        protected Float addOvernightFee;
        /** 大型车加收过夜费，单位元 */
        protected Float addOvernightFeeBig;
    }

    @Data
    public static class DurationInfo {
        /** 超出多少分钟配置是否起作用 1：是 2否 */
        protected Integer isOverTimeSet;
        /** 超过分钟数，单位分钟 */
        protected Integer overTime;
        /** 单位时长，单位分钟 */
        protected Integer feespantime;
        /** 小型车单位金额，单位元 */
        protected Float feespanrate;
        /** 大型车单位金额，单位元 */
        protected Float feespanrateBig;
        /** 阶梯计费详情 */
        protected List<StepChargeDetail> stepChargeDetails;
    }

    @Data
    public static class StepChargeDetail {
        /** 计时开始时间，单位分钟 */
        protected Integer startTimeModule;
        /** 计时结束时间，单位分钟 */
        protected Integer endTimeModule;
        /** 单位时长，单位分钟 */
        protected Integer feespantime;
        /** 小型车单位金额，单位元 */
        protected Float feespanrate;
        /** 大型车单位金额，单位元 */
        protected Float feespanrateBig;
    }

    @Data
    public static class Hour24Info {
        /** 免费时长（分钟） */
        protected Integer freetime;
        /** 累计24小时免费时长是否使用多次 （1：24小时免费时长可用一次，2：每次进场都可用 ，默认2） */
        protected Integer isFreetimeOnce;
        /** 是否使用一天最大收费限额(一天) 0：禁用  1：启用 默认为0 */
        protected Integer daynightmaxfeeusing;
        /** 最大收费限额类型1=单天单次最高收费 2=单天最高收费 3=24小时最高收费 */
        protected Integer daynightmaxfeetype;
        /** 24小时统计方式 1=以24小时内的订单入场时间为准 2=以24小时之内的出场时间判断 */
        protected Integer daynightmaxfeecounttype;
        /** 小型车单天最高收费金额，单位元 */
        protected Float daynightmaxfee;
        /** 大型车单天最高收费金额，单位元 */
        protected Float daynightmaxfeeBig;
        /** 时间分割分钟数，单位分钟，会将一天24小时按分割分钟数等额平均分开来设置计费； */
        protected Integer divisionTime;
        /** 是否启用跨天后收费， 1：是， 2：否， 默认为2 */
        protected Integer isOverTimeSet;
        /** 跨天后每间隔多长时间，单位分钟 */
        protected Integer feespantimestep;
        /** 小型车跨天后单位费用，单位元 */
        protected Float feespanratestep;
        /** 大型车跨天后单位费用，单位元 */
        protected Float feespanratestepBig;
        /** 是否区分大小型车计费（0：否，1：是） */
        protected Integer isSmallbigcarSet;
        /** 24小时计费详情 */
        protected List<Hour24Detail> details;
    }

    @Data
    public static class Hour24Detail {
        /** 是否有数据，0：无数据，1：有数据； */
        protected Integer recordStatus;
        /** 计费时间点，单位分钟；如1.5小时，此值为90； */
        protected Integer feespantime;
        /** 小型车单位费用，单位元 */
        protected Float feespanrate;
        /** 大型车单位费用，单位元 */
        protected Float feespanrateBig;
    }
}
