package com.icetech.cloudcenter.domain.request.pnc;

import java.io.Serializable;
import java.util.List;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 端网云架构通道
 */
@ToString
@Setter
@Getter
public class ChannelRulesRequest implements Serializable {
    /**
     * 区域编号
     */
    private String regionCode;
    /**
     * 操作类型 1=添加 2=修改 3=删除
     */
    private Integer operType = 1;
    /**
     * 通道编号
     */
    private String inandoutCode;
    /**
     * 是否是主通道 1=是 0=否
     */
    private Integer isMaster;
    /**
     * 是否收费  1=是 0=否
     */
    private Integer isCharge;
    /**
     * 通道名称
     */
    private String inandoutName;
    /**
     * 通道类型，1入口 2出口
     */
    private Integer inandoutType;
    /**
     * 是否允许临时车进出 0:不允许  1：允许
     */
    private Integer isAllowTempcarrun;
    /**
     * 是否允许无牌车扫码进出 0:不允许  1：允许
     */
    private Integer isAllowNocardrun;
    /**
     * 黄牌车是否允许进 0:不开启  1：开启
     */
    private Integer isAllowYellowcarrun;
    /**
     * 是否开启模糊识别 0:不开启  1：开启
     */
    private Integer isOpenVaguetype;
    /**
     * 模糊模式 0：去汉字 1：去汉字1位 2：去汉字2位
     */
    private Integer vagueType;
    /**
     * 是否允许新能源车辆进出 0：不允许 1：允许
     */
    private Integer isAllowNewenergycarrun;
    /**
     * 是否允许预约车进出0：不允许，1：允许
     */
    private Integer isAllowVisitCar;
    /**
     * 是否允月卡车车进出0：不允许，1：允许
     */
    private Integer isAllowMonthCar;
    /**
     * 是否允许过期月卡车进出0：不允许，1：允许
     */
    private Integer isOverTimeMonth;
    /**
     * 过期天数 isOverTimeMonth=1必填
     */
    private Integer overTimeDay;
    /**
     * 过期卡是否按月卡处理0：否，1：是 isOverTimeMonth=1必填
     */
    private Integer overTimeMonthlyCard;
    /**
     * 过期X天按月卡处理，overTimeMonthlyCard为是时必填
     */
    protected Integer expireMcDays;
    /**
     * 是否允许黑名单车进出0：不允许，1：允许
     */
    private Integer isAllowBackCar;
    /**
     * 是否允许Vip车进出0：不允许，1：允许
     */
    private Integer isVipCar;
    /**
     * 多个以逗号隔开
     */
    private String vipCarType;
    /**
     * 是否允许多位多车月卡车进出1=是 0=否
     */
    private Integer isAllowABcar;
    private Integer isAllowBluerun;
    /**
     * 是否允许储值卡车进出0：不允许，1：允许
     */
    private Integer isAllowStoredCar;
    /** 显示终端类型，1：LED，2：LCD */
    protected Integer screenType;
    /**
     * 控制卡型号
     */
    private Integer ctrlCardModel;
    /**
     * 是否有TTS 1：有，2：没有
     */
    private Integer isSupportTTS;
    /**
     * 放行时间段类型，1：全天放行，2：分时段放行，放行时间管理功能打开时有效
     */
    private Integer rangeType;
    /**
     * 区分工作日和非工作日标识，0：不区分，1：区分，分时段放行时有效
     */
    private Integer diffWorkDay;

    /**
     * 设备信息
     */
    private List<DeviceRequest> devices;
    /**
     * 通道权限扩展配置
     */
    private List<ChannelRuleExtendRequest> channelRules;
}
