package com.icetech.cloudcenter.domain.request.pnc;

import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * 批量置为离场数据
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
public class BatchSetExitRequest {
    /**
     * 服务类型-批量置为离场
     */
    public static final Integer SERVICE_TYPE_EXIT = 1;

    /**
     * 业务类型，1：批量置为离场
     */
    protected Integer serviceType;
    /**
     * 务类型为1时，车辆入场接口的orderId
     */
    protected List<String> idList;

    /**
     * 是否同步空车位:0不需要同步;1同步
     */
    protected Integer syncFlag = 0;
}
