package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 端云架构设备注册参数类
 */
@ToString
@Setter
@Getter
public class RegisterDeviceRequest implements Serializable {

    @NotNull
    private String cmd;
    @NotNull
    private String messageId;
    @NotNull
    private String parkCode;
    @NotNull
    private String deviceNo;
    private String deviceIp;
//    @NotNull
    private String sign;
    @NotNull
    private Long timestamp;
    @NotNull
    private String version;
    /**
     * 产品型号
     */
    private String productModel;
    /**
     * 固件版本号
     */
    private String firmwareVersion;

    /**
     * 来源，1：华夏相机直连，2：阿里物联网平台
     */
    private Integer source = 1;

}
