package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * 属性上报接口
 */
@ToString
@Setter
@Getter
public class PropertyInfoRequest implements Serializable {

    private String parkCode;
    @NotNull
    private Integer enexType;
    @NotNull
    private String deviceIp;
    @NotNull
    private Long tzDiffSec;
    @NotNull
    private String version;
    /**
     * 产品型号
     */
    @NotNull
    private String productModel;
    /**
     * 固件版本号
     */
    @NotNull
    private String firmwareVersion;
    /**
     * 网络连接方式，1:无线，2:有线
     */
    private Integer connectionMode;
    /**
     * 无线网络运营商，1:移动，2:电信，3：联通，99：未知
     */
    private Integer wirelessCarrier;
    /**
     * 第几代无线网，例：5G、4G、3G、2G
     */
    private String network;

    /**
     * 滞留算法开关，0：关，1：开
     */
    private Integer retentionAlarm;

    /**
     * 滞留时间阈值，单位秒，范围在30到600
     */
    private Integer retentionTimeThreshold;

    /**
     * 滞留报警方式，1：一次，2：多次
     */
    private Integer retentionAlarmMethod;

    /**
     * 滞留重复报警间隔时间，范围在5到600；滞留报警方式为多次时，此值有效
     */
    private Integer retentionIntervalTime;
    /**
     * 是否开启虚假车牌识别功能，0：关闭，1：打开
     */
    private Integer enableShamPlate;
    /**
     * 虚假车牌处理方式，1：报警，2：过滤
     */
    private Integer shamPlateMethod;
    /**
     * 支持新版本蓝牙，0：否，1：是
     */
    private Integer newBluetooth;
    /**
     * 支持的文件资源服务器列表，1：阿里云、2：腾讯云、3：百度云、4：华为云、5：华夏自建云、6：网易云、7：七牛云、8：天翼云，不传默认支持1
     */
    private List<Integer> supportOssType;

}
