package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.common.annotation.NotNull;
import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

@Data
public class LcdConfigRequest extends Request implements Serializable {

    @NotNull
    private Integer lineNum;
    private Integer remainDaysMc;
    @NotNull
    private Integer expireDaysMc;
    @Deprecated
    private Integer isExpireMc;
    @NotNull
    private Integer restoreDefaultTime;
    @NotNull
    private Integer volumeValue;
    @NotNull
    private Integer quietHoursSwitch;
    private String quietStartTime;
    private String quietEndTime;
    private Integer quietVolumeValue;
    private Integer limitType;
    private String limitDriveNum1;
    private String limitDriveNum2;
    private String limitDriveNum3;
    private String limitDriveNum4;
    private String limitDriveNum5;
    private String parkName;
    private Integer freeSpace;
    private String entraceFreePerLineColor;
    private Integer entraceFreeShowType;
    private String enterPerLineColor;
    private Integer enterShowType;
    private String exitFreePerLineColor;
    private Integer exitFreeShowType;
    private String exitPerLineColor;
    private Integer exitShowType;
    private String dynamicQR;
    private Integer blackCar;

    //since V1.5.1
    private Integer realFreeSpace;
    private Integer totalSpace;

    @NotNull
    private List<BrightnessControl> brightnessControl;
    @NotNull
    private List<ShowConfig> showConfig;
    @NotNull
    private List<SoundConfig> soundConfig;

    @Setter
    @Getter
    @ToString
    public static class BrightnessControl implements Serializable{
        @NotNull
        private String startTimePoint;
        @NotNull
        private String endTimePoint;
        @NotNull
        private Integer brightnessVal;
    }
    @Setter
    @Getter
    @ToString
    public static class ShowConfig implements Serializable{
        @NotNull
        private Integer showScene;
        @NotNull
        private String content;
    }
    @Setter
    @Getter
    @ToString
    public static class SoundConfig implements Serializable{
        @NotNull
        private Integer sayScene;
        @NotNull
        private String content;
    }
    public enum SceneEnum {
        月卡车入场(1), 其他允许的入场(2), 月卡车离场(3), 其他无需缴费的离场(4), 入口空闲显示(5), 出口空闲显示(6),
        临时车入场不允许临时车进(7), 黑名单车辆入场(8), 其他不允许入场的车辆(9), 多位多车入场车位占用(10),
        入场月卡过期(11), 黑名单车出场(12), 无牌车出场(13), 出场需缴费(14), 出场无入场记录(15), 入场虚假车牌(16), 出场虚假车牌(17),
        ;
        public int scene;
        private SceneEnum(int scene){
            this.scene = scene;
        }
    }

    @Override
    public Request buildByVersion(String version){
        if (P2cVersionEnum.版本9.getIndex() <= P2cVersionEnum.getIndex(version)){
            this.setIsExpireMc(null);
        }
        if (P2cVersionEnum.版本18.getIndex() > P2cVersionEnum.getIndex(version)){
            this.showConfig.removeIf(next -> next.getShowScene() > 15);
            this.soundConfig.removeIf(next -> next.getSayScene() > 15);
        }
        return this;
    }
}

