package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.common.annotation.NotNull;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Setter
@Getter
@ToString
public class FreeSpaceRequest extends Request {

    @NotNull
    private Integer freeSpace;
    //since V1.5
    private Integer realFreeSpace;
    private Integer totalSpace;
    private Integer showFreeSpace;
    private String showFreeSpaceName;
    @NotNull
    private Long time;

    @Override
    public Request buildByVersion(String version){
        if (P2cVersionEnum.版本3.getIndex() > P2cVersionEnum.getIndex(version)){
            throw new ResponseBodyException(CodeConstants.ERROR_407, "当前相机版本号过低，无法下发，请升级");
        }
        return this;
    }
}

