package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.NumberUtils;
import lombok.*;

import java.io.Serializable;

/**
 * 端云架构名单清空参数类
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ClearListRequest extends Request implements Serializable {

    private Integer dataType;
    private Integer id;

    @Override
    public Request buildByVersion(String version){
        //vip删除要在1.3后才能下发
        if (NumberUtils.toPrimitive(dataType) == 3
                && P2cVersionEnum.版本4.getIndex() > P2cVersionEnum.getIndex(version)){
            throw new ResponseBodyException(CodeConstants.ERROR_407, "当前相机版本号过低，无法下发，请升级");
        }
        //预约车删除
        if (NumberUtils.toPrimitive(dataType) == 5
                && P2cVersionEnum.版本9.getIndex() > P2cVersionEnum.getIndex(version)) {
            throw new ResponseBodyException(CodeConstants.ERROR_407, "当前相机版本号过低，无法下发，请升级");
        }
        return this;
    }
}
