package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 端云架构设备注册参数类
 */
@ToString
@Setter
@Getter
public class ChannelRulesRequest extends Request implements Serializable {

    private Integer issupTempcar;
    private Integer isAllowNocardrun;
    private Integer vagueInfo;
    private Integer freetime;
    private Integer isfreeAfterpay;
    private Integer isfreeSpecialcar;
    private Integer issupAbmanage;
    private Integer isupimage;
    private Integer isAllowYellowcarrun;
    private Integer cacheExpires;

    private Integer overtimeBillType;
    private Integer isnotgetsmallchange;
    private Integer freetimeStatus;
    private Integer isFilltime;
    private Integer isallowfreetmonce;
    private Integer chargeVersionNum;
    private Integer billPrecision;
    private Integer isfixedfees;
    private Integer fixedfeevalue;
    /**
     * 进出是否共用一个通道，1：是，0：否，默认为0
     */
    private Integer isSpecialPark;
    /**
     * 入场X秒不让出场，isSpecialPark为1时必传
     */
    private Integer enexMinTime;
    /**
     * 出场X秒不让进场，isSpecialPark为1时必传
     */
    private Integer exenMinTime;

    private Integer isAllowBlackCar;
    private Integer isAllowBluerun;
    private Integer isAllowNewenergycarrun;
    private Integer isAllowVisitCar;
    private Integer isAllowMonthCar;
    private Integer overTimeDay;
    private Integer isExpireMc;
    private Integer isAllowAbcar;
    private Integer isAllowStoredCar = 1;
    private Integer isAllowVipCar;
    private String vipCarTypeId;
    private Integer fixedFeeValueBig;
    
    //since V1.5.1
    private Integer fullEmptynum;
    private Integer isFullForbidenter;
    private Integer isFullForbidmonthenter;
    private Integer isFullForbidreserventer;
    private Integer isFullForbidstoreenter;
    private Integer isFullForbidblackenter;
    private Integer isFullForbidvipenter;
    private String fullVipCarTypeId;
    private Integer isCardcount;
    private String showQrCodeUrl;
    private String moneyunitType;
    private Integer nestType;
    private Long regionId;
    private String regionName;
    private Integer isMaster;
    private Integer switchFreeTime;
    private Integer regionType;
    /**
     * 运行模式，1：标准模式、2：纯云模式，默认为1
     */
    private Integer runningMode;

    public void setIsAllowStoredCar(Integer isAllowStoredCar) {
        if (isAllowStoredCar == null) {
            this.isAllowStoredCar = 1;
        }else{
            this.isAllowStoredCar = isAllowStoredCar;
        }
    }
    @Override
    public Request buildByVersion(String version) {
        if (P2cVersionEnum.getIndex(version) < P2cVersionEnum.版本20.getIndex()) {
            if (this.runningMode != null && this.runningMode == 2) {
                this.setIssupTempcar(0);
                this.setIsAllowNocardrun(0);
                this.setIsAllowYellowcarrun(0);
                this.setIsAllowBlackCar(0);
                this.setIsAllowBluerun(0);
                this.setIsAllowNewenergycarrun(0);
                this.setIsAllowVisitCar(0);
                this.setIsAllowMonthCar(0);
                this.setIsAllowAbcar(0);
                this.setIsAllowStoredCar(0);
                this.setIsAllowVipCar(0);
            }
        }
        return this;
    }

}
