package com.icetech.cloudcenter.domain.request.mor;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 属性上报接口
 */
@ToString
@Setter
@Getter
public class MorPropertyInfoRequest implements Serializable {

    @NotNull
    private String deviceIp;
    @NotNull
    private Long tzDiffSec;
    @NotNull
    private String version;
    /**
     * 产品型号
     */
    @NotNull
    private String productModel;
    /**
     * 固件版本号
     */
    @NotNull
    private String firmwareVersion;
    /**
     * 网络连接方式，1:无线，2:有线
     */
    private Integer connectionMode;
    /**
     * 无线网络运营商，1:移动，2:电信，3：联通，99：未知
     */
    private Integer wirelessCarrier;
    /**
     * 第几代无线网，例：5G、4G、3G、2G
     */
    private String network;
    /**
     * 视频码率，仅支持 512，768，1024，2048，4096
     */
    private Integer videoKbps;
    /**
     * 视频分辨率，仅支持 720/760/1080/1296
     */
    private Integer videoDpi;


}
