package com.icetech.cloudcenter.domain.request.itc;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 端云立语音显示参数类
 */
@ToString
@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class HintRequest implements Serializable {

    private Integer scene;
    private String plateNum;
    private Integer type;
    private String vipTypeName;
    private Integer remainDaysMc;
    private Integer freeSpace;
    private Long parkTime;
    private Integer unpayPrice;
    private String qrCodeUrl;

    @Getter
    @ToString
    public enum Scene {
        //月卡车入场
        MONTH_CAR_ENTER(1),
        //其他车允许入场
        OTHER_ENTER(2),
        //无牌车需扫码入场
        NO_PLATE_ENTER(3),
        //月卡过期不允许入场
        MONTH_CAR_NOT_ALLOW_EXPIRE(4),
        //多位多车入场车位占用不允许入场
        MULTI_SPACE_NOT_ALLOW_ENTER(5),
        //黑名单不允许入场
        BLACK_NOT_ALLOW_CAR_ENTER(6),
        //车位满不允许入场
        FULL_NOT_ALLOW_ENTER(7),
        //其他不允许入场
        OTHER_CAR_NOT_ALLOW_ENTER(8),
        //无需缴费出场
        NO_FEE_EXIT(9),
        //其他不允许出场
        NOT_ALLOW_EXIT(10),
        //无牌车出场
        NO_PLATE_EXIT(11),
        //出场需缴费
        NEED_PAY_EXIT(12),
        //出场无入场记录
        NO_ORDER_EXIT(13),
        ;

        private int val;

        Scene(int val){
            this.val = val;
        }
    }
}
