package com.icetech.cloudcenter.domain.request;

import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.common.annotation.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 远程开关闸请求参数
 * @author fangct
 */
@Setter
@Getter
@ToString
public class RemoteSwitchRequest implements Serializable {
    @NotNull
    private String parkCode;
    @NotNull
    private String deviceNo;
    @NotNull
    private String channelId;
    @NotNull
    private Integer switchType;
    @NotNull
    private String sequenceId;
    private Integer inoutEvent;;
    private String operAccount;
    private Integer exTerminal;
    private String plateNum;
    private Integer reasonType;
    private String remark;

    public enum ExtraInfoEnum {
        //移动端查询费用
        OPEN("open"),
        CLOSE("close"),
        ;
        public String val;
        ExtraInfoEnum(String val){
            this.val = val;
        }
    }

    @Setter
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class ExtraInfo<T> {
        private String biz;
        private T requestVO;
    }
}
