package com.icetech.cloudcenter.domain.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 缴费查询
 * @author fangct
 */
@Data
public class QueryFeeRequest implements Serializable {
    /**
     * 车场ID
     */
    private Long parkId;
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 车场key
     */
    private String key;
    /**
     * 本地订单号
     */
    private String orderId;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 通道ID
     */
    private String channelId;
    /**
     * 车型，1：小型车，2：大型车
     */
    private Integer carType;
    /**
     * 异步回调的topic
     */
    private String topic;
    private String extraInfo;

    public enum ExtraInfoEnum {
        /** 移动端查询费用 */
        PULL_FEE("pullFee"),
        ;
        public String val;
        ExtraInfoEnum(String val){
            this.val = val;
        }
    }
}
