package com.icetech.cloudcenter.domain.request;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * 预约入场
 * @author fangct
 */
@Data
public class OrderEnterRequest implements Serializable {

    /**
     * 车场名称
     */
    @NotNull
    private String parkCode;
    /**
     * 车牌号
     */
    @NotNull
    private String plateNum;
    /**
     * 开始时间
     */
    @NotNull
    private Long startTime;
    /**
     * 结束时间
     */
    @NotNull
    private Long endTime;
    /**
     * 是否免费，0：否，1：是
     */
    private Integer isFree = 0;
    /**
     * 是否允许多次进入，0：一次，1：多次  2:自定义次数
     */
    @NotNull
    private Integer isAllowManyTimes;
    /**
     * 自定义次数
     */
    private Integer allowVisitNum;

    /**
     * 预约ID(为删除预约时候用)
     */
    private Long visitId;
}
