package com.icetech.cloudcenter.domain.request;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 停车入库
 */
@Data
public class JinDiParkRequest implements Serializable {
    private List<Map> cars;
    /**
     * 主车牌号
     */
    private String mainCar;
    /**
     *
     */
    private Integer count;
    private String parkCode;
    private Date startTime;
    private Date endTime;
    /**
     * 该值为2时，payment_method值为-1,payment_time值为null 1: 代表长租 2: 代表免费车
     */
    private Integer parkingType;
    /**
     * o支付方式，有如下6种类别
     * 1: 支付宝支付
     * 2: 微信支付
     * 3: POS机刷卡
     * 4: 对公转账
     * 5: 支付宝转账
     * 6: 联盟付  类似聚合支付
     */
    private Integer paymentMethod;
    private Double totalPrice;
    private String paymentTime;

    /**
     * 金地支付方式转换平台支付方式
     * @param jinDiType
     * @return
     */
    public static Integer convertJinDiPayMethod(Integer jinDiType){
        if (Objects.isNull(jinDiType)) return 0;
        if (jinDiType ==1 ){
            //支付宝
            return 3;
        }
        if (jinDiType == 2){
            //微信
            return 2;
        }
        //其他
        return 4;
    }
}
