package com.icetech.cloudcenter.domain.request;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 固件列表查询接口
 */
@ToString
@Setter
@Getter
public class FirmwareListRequest implements Serializable{

    /**
     * 设备型号ID
     */
    private Integer productModelId;
    /**
     * 固件版本号
     */
    private String firmwareVersion;
    /**
     * 添加开始时间
     */
    private String startTime;
    /**
     * 添加结束时间
     */
    private String endTime;
    /**
     * 当前加载的页码
     */
    private Integer pageNo = 1;
    /**
     * 每页显示的记录数
     */
    private Integer pageSize = 10;

}
