package com.icetech.cloudcenter.domain.request;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * 入场测试
 * @author fangct
 */
@Data
public class ExitDebugRequest implements Serializable {
    /**
     *车场编号
     */
    @NotNull
    private String parkCode;
    /**
     *通道编号
     */
    @NotNull
    private String aisleCode;
    /**
     * 车牌号
     */
    @NotNull
    private String plateNum;
    /**
     * 离场时间
     */
    @NotNull
    private Long exitTime;
    /**
     * 车辆类型，1临时车 2月卡车 3特殊车辆 4VIP车辆 5黑名单
     */
    @NotNull
    private Integer type;
}

