package com.icetech.cloudcenter.domain.request;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * 设备列表查询接口
 */
@ToString
@Setter
@Getter
public class DeviceListRequest implements Serializable{

    /**
     * 车场ID列表
     */
    private List<Long> parkIdList;
    /**
     * 设备类型
     */
    private Integer deviceType = 1;
    /**
     * 设备型号ID
     */
    private Integer productModelId;
    /**
     *  设备序列号
     */
    private String sn;
    /**
     * 设备状态,0未连接 1在线 2离线 3故障
     */
    private Integer deviceStatus;
    /**
     * 当前加载的页码
     */
    private Integer pageNo = 1;
    /**
     * 每页显示的记录数
     */
    private Integer pageSize = 10;

}
