package com.icetech.cloudcenter.domain.request;


import com.icetech.park.domain.dto.TagsDto;
import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

@Setter
@Getter
@ToString
public class CarEnterRequest implements Serializable {

    //接口参数开始
    @NotNull
    private Integer openFlag;
    @NotNull
    private Integer property;
    private String plateNum;
    @NotNull
    private Long enterTime;
    @NotNull
    private Integer triggerType;
    private String plateColor;
    private Integer shamFlag;
    private Integer carType;
    private Integer reliability;
    private Integer type;
    private String carDesc;
    private String carBrand;
    private String carColor;
    private String smallImage;
    private String maxImage;

    @NotNull(condition = "triggerType == 3")
    private String triggerNo;

    //接口参数结束

    /**
     * 辅助参数
     */
    //出入口名称
    private String inandoutName;
    private String inandoutCode;
    private String parkCode;
    private Long parkId;
    private String orderNum;
    /**
     * 操作用户
     */
    private String operaUser;
    /**
     * 入场方式：1车牌识别入场，2遥控器抬杆入场，3无牌车扫码入场，4软件人工入场
     */
    private Integer enterWay;
    /**
     * 无进场记录标识
     */
    private boolean noneEnterFlag = false;
    /**
     * 是否补录订单
     */
    private boolean isReplenishOrder = false;
    //是否调试模式
    private boolean isDebug = false;
    /**
     * 标签集
     */
    private List<TagsDto> tags;
    private String remark;
    /**
     * 人工入场的渠道
     */
    private Integer enterTerminal;
    /**
     * 是否已经添加了订单
     */
    private boolean addedOrder;

    public boolean getNoneEnterFlag() {
        return noneEnterFlag;
    }

}
