package com.icetech.cloudcenter.domain.pay;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 月卡开卡附加信息
 * @author wangzhiwei
 */
@Data
public class MonthOpenCardDto implements Serializable {
    /**
     * 业务类型(不传)
     */
    private Integer bizType = BizType.MONTH_OPEN_PAY.getBizType();
    /**
     * 月卡产品id
     */
    private Integer productId;
    /**
     * 订单ID
     */
    private Long orderId;
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 购买数量
     */
    private Integer buyNum;
    /**
     * 车位数
     */
    private Integer plotCount = 1;

    /**
     * 产品面额（1个月2个月等）
     */
    private Integer duration;
    /**
     * 赠送天数
     */
    private Integer diftDays;
    /**
     * 手机号
     */
    private String phone;
    /**
     * 月卡申办性质，1个人 2公司
     */
    private Integer cardProperty = 1;
    /**
     * 用户姓名/公司名称
     */
    private String cardOwner;
    /**
     * 车主地址
     */
    private String mainAddress;
    /**
     * 验证码
     */
    private String verCode;
    /**
     * 备注
     */
    private String remark;
    /**
     * 月卡开始时间(不传)
     */
    private Date startDate;
    /**
     * 月卡结束时间(不传)
     */
    private Date endDate;
    /**
     * 支付金额
     */
    private BigDecimal payMoney;
    /**
     * 支付方式(不传)  0 现金，1 银行卡 2：微信 3：支付宝
     */
    private Integer payMethod;
    /**
     * 支付渠道(不传) 1 云平台 2：App 3：公众号 4 小程序
     */
    private Integer payChannel;
    /**
     * 操作人(不传)
     */
    private Integer mpUserId;
    /**
     * 操作人
     */
    private String userName;
    /**
     * 交易流水号
     */
    private String tradeNo;
    /**
     * 商户交易流水号
     */
    private String outTradeNo;
    /**
     * 支付时间
     */
    private Long payTime;

    /**
     * 图片数据
     */
    private List<PicData> picData;
    /**
     * 车牌数据
     */
    private List<PlateNumData> plateNumData;

    /**
     * 操作类型1 新增 2 续费 3 修改 4 退卡
     */
    private int cardOpertype = 1;

    @Data
    public static class PlateNumData implements Serializable{
        /**
         * 车牌号
         */
        private String plateNum;
   }
   @Data
    public static class PicData implements Serializable {
        /**
         * 图片类型 0:行驶证 1：身份证 2：其他资料 3营业执照
         */
        private int picType;
       /**
        * 图片路径
        */
       private String picUrl;
   }
}
