package com.icetech.cloudcenter.domain.pay;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author wanggang
 * @create 2025-02-14 15:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class MiniOrdersDTO implements Serializable {

    private Integer bizType = BizType.MINI_OPEN_PAY.getBizType();

    /**
     * 正常停车订单号
     */
    private String orderNum;

    /**
     * 欠费停车订单号
     */
    private List<String> orderNums;

    /**
     * 商户交易流水号
     */
    private String outTradeNo;

    Map<String, String> tradeNoMap;
    /**
     * 支付时间
     */
    private Long payTime;

}
