package com.icetech.cloudcenter.domain.pay;

import lombok.Data;

import java.io.Serializable;

/**
 * 商户充值
 * @author wangzhiwei
 */
@Data
public class MerchantRechargeDto implements Serializable {

    /**
     * 4=商户充值
     */
    private Integer bizType = BizType.DISCOUNT_PAY.getBizType();
    /**
     * 商户编码
     */
    private String merchantCode;
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 车场id
     */
    private Long parkId;
    /**
     * 交易流水号
     */
    private String tradeNo;
    /**
     * 操作人
     */
    private String operator;
    /**
     * 充值金额
     */
    private String amount;
    /**
     * 缴费方式 1现金，2微信，3支付宝
     */
    private Integer payWay;
    /**
     * 充值方式 1:saas平台 2:微信小程序
     */
    private Integer rechargeType;
}
