package com.icetech.cloudcenter.domain.parkvip;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 会员套餐规则
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_vip_product_rule")
public class VipProductRule implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 产品名称
     */
    private String productName;

    /**
     * vip 配置id
     */
    private Integer vipId;

    /**
     * 通道最小值
     */
    private Integer channelMinNum;

    /**
     * 通道最大值
     */
    private Integer channelMaxNum;

    /**
     * 套餐类型
     */
    private Integer productType;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 活动价
     */
    private BigDecimal discountAmount;

    /**
     * 是否是推荐套餐 默认0 1=推荐
     */
    private Integer recommend;
    /**
     * 描述
     */
    private String remark;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
