package com.icetech.cloudcenter.domain.parkvip;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;

import java.io.Serializable;

/**
 * @author wangzhiwei
 */
@AllArgsConstructor
@Getter
public enum VipEquitiesEnum {
    滞留车辆推送(1,"滞留车辆推送","E1001"),
    云端二次识别(2,"云端二次识别","E1002"),
    车主呼叫(3,"车主呼叫","E1003"),
    收费员呼出(4,"收费员呼出","E1004"),
    ;
    private Integer type;
    private String name;
    private String code;

    /**
     * 获取编码
     * @param type
     * @return
     */
    public static String getCode(Integer type){
        for (VipEquitiesEnum value : VipEquitiesEnum.values()) {
            if (value.getType().equals(type)){
                return value.getCode();
            }
        }
        return null;
    }

    public static VipEquitiesEnum getEntity(String code){
        for (VipEquitiesEnum value : VipEquitiesEnum.values()) {
            if (value.getCode().equals(code)){
                return value;
            }
        }
        return null;
    }

    /**
     * 获取名称
     * @param type
     * @return
     */
    public static String getName(Integer type){
        for (VipEquitiesEnum value : VipEquitiesEnum.values()) {
            if (value.getType().equals(type)){
                return value.getName();
            }
        }
        return null;
    }
}
