package com.icetech.cloudcenter.domain.parkvip;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 会员开通记录
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_vip_buyer_record")
public class VipBuyerRecord implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * vipid
     */
    private Integer vipId;

    /**
     * 交易流水号
     */
    private String tradeNo;

    /**
     * 第三方交易流水号
     */
    private String outTradeNo;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 支付方式
     */
    private Integer payWay;

    /**
     * 套餐规则id
     */
    private Integer vipRuleId;

    /**
     * 下单时间
     */
    private Date orderTime;

    /**
     * 过期时间
     */
    private Date expirationTime;
    /**
     * 描述
     */
    private String remark;
    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
