package com.icetech.cloudcenter.domain.park;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhangpengzhan
 * @date 2021/5/31 11:46
 * @description:
 */
@Data
@NoArgsConstructor
public class ParkChannelListPage<T> implements Serializable {

    @ApiModelProperty(value = "总记录数", required = true, example = "100", position = 1)
    private long total;

    @ApiModelProperty(value = "总页数", required = true, example = "10", position = 2)
    private String totalPage;

    @ApiModelProperty(value = "返回数据结果", required = true, position = 3)
    private List<T> rows;

    public ParkChannelListPage(long total, String totalPage, List<T> rows) {
        this.total = total;
        this.totalPage = totalPage;
        this.rows = rows;
    }
}
