package com.icetech.cloudcenter.domain.park;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhangpengzhan
 * @date 2021/5/31 11:34
 * @description:
 */
@Data
public class ParkChannelInfo implements Serializable {

    @ApiModelProperty(value = "车场名称", required = true, example = "test001", position = 1)
    private String parkName;

    @ApiModelProperty(value = "通道编码", required = true, example = "123451", position = 2)
    private String channelCode;

    @ApiModelProperty(value = "通道名称", required = true, example = "出1", position = 3)
    private String channelName;

    @ApiModelProperty(value = "通道类型，1入口 2出口", required = true, example = "1", position = 4)
    private Integer inandoutType;

    @ApiModelProperty(value = "通道类型，1入口 2出口", required = true, example = "1", position = 5)
    private String regionCode;

    @ApiModelProperty(value = "是否是主通道，1=是0=否，默认为1", required = true, example = "1", position = 6)
    private Integer isMaster;

    @ApiModelProperty(value = "是否收费 1=是 0=否", required = true, example = "1", position = 7)
    private Integer isFee;
}
