package com.icetech.cloudcenter.domain.notpay;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Description: 虚假车牌列表
 * @Author: fangct
 * @CreateTime: 2023-07-20  10:31
 * @Version: 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ShamPlateListVO implements Serializable {
    /**
     * 车场编号
     */
    private String parkCode;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 开始时间
     */
    @NotBlank(message = "查询开始时间不能为空")
    private String startTime;

    /**
     * 结束时间
     */
    @NotBlank(message = "查询结束时间不能为空")
    private String endTime;

    /**
     * 每页条数
     */
    private Integer pageSize = 10;

    /**
     * 页码
     */
    private Integer pageNum = 1;
}
