package com.icetech.cloudcenter.domain.notpay;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @Description: 虚假车牌查询DTO
 * @Author: wanggang
 * @CreateTime: 2023-07-31  10:31
 * @Version: 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class SassShamPlateQueryDTO implements Serializable {

    /**
     * 车场ids
     */
    private List<Long> parkIds;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 查询开始时间
     */
    @NotBlank(message = "查询开始时间不能为空")
    private String startTime;

    /**
     * 查询结束时间
     */
    @NotBlank(message = "查询结束时间不能为空")
    private String endTime;

    /**
     * 第几页
     */
    private Integer pageNo = 1;

    /**
     * 每页展示多少条
     */
    private Integer pageSize = 10;
}
