package com.icetech.cloudcenter.domain.notpay;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Description NotPayDeleteDTO
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/3/23 17:53
 */
@Data
public class NotPayDeleteDTO implements Serializable {

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 车场编码
     */
    private String parkCode;

    /**
     * 通道编号
     */
    private String aisleCode;

    /**
     * id 集合
     */
    private List<Integer> ids;

    /**
     * 删除原因
     */
    private String reason;

    private List<DelNotePay> delNotePays;

    @Data
    public static class DelNotePay{

        private Long parkId;

        private Integer id;

        /**
         * 通道编号
         */
        private String aisleCode;
    }

}
