package com.icetech.cloudcenter.domain.enumeration;

import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import lombok.Getter;

@Getter
public enum ItcVersionEnum {

    版本1("1.0", 1),
    ;

    private String version;
    private int index;

    private ItcVersionEnum(String version, int index){
        this.version = version;
        this.index = index;
    }
    public static int getIndex(String version){
        if (version == null){
            return 0;
        }
        for (ItcVersionEnum p2cVersionEnum : ItcVersionEnum.values()){
            if (p2cVersionEnum.version.equals(version)){
                return p2cVersionEnum.index;
            }
        }
        String newVersion = version.replace(".", "");
        String maxVersion = 版本1.getVersion().replace(".", "");
        if (NumberUtils.parseInteger(newVersion) > NumberUtils.parseInteger(maxVersion)) {
            return 版本1.getIndex();
        }
        return 0;
    }
    
    public static float getNumber(String version) {
        if (StringUtils.isBlank(version)) {
            return 0;
        }
        String[] split = version.split("\\.");
        if (split.length == 1) {
            return 0;
        }
        String newVer = split[0] + ".";
        for (int i = 1; i < split.length; i++) {
            String node = split[i];
            String tempNode = node.length() == 1 ? "0" + node : node;
            newVer = newVer + tempNode;
        }
        return Float.parseFloat(newVer);
    }

}
