package com.icetech.cloudcenter.domain.enumeration;

import lombok.Getter;

@Getter
public enum CodeEnum {

    成功(200,"成功"),
    服务器异常(500, "服务器异常"),
    缺失参数(400, "缺失参数/格式不正确"),
    认证失败(401, "认证失败"),
    非法参数(402, "非法参数"),
    请求方式错误(403, "请求方式错误"),
    请求重复(405, "请求重复"),
    请求资源不存在(404, "请求资源不存在"),
    设备SN不存在(12001, "设备SN不存在"),
    未关联通道信息(44001, "未关联通道信息"),
    ;

    private Integer code;
    private String msg;

    private CodeEnum(Integer code, String msg){
        this.code = code;
        this.msg = msg;
    }

    public static String getMsg(Integer code){
        for (CodeEnum codeEnum : CodeEnum.values()) {
            if (code.equals(codeEnum.getCode())){
                return codeEnum.getMsg();
            }
        }
        return "";
    }
}
