package com.icetech.cloudcenter.domain.customer;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author wanggang
 * @create 2023-11-24 13:41
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class UpdateCustomerDTO implements Serializable {

    /**
     * id主键
     */
    private Long id;

    /**
     * 客服机构id
     */
    @NotNull(message = "客服所在的机构id不能为空")
    private Long institutionId;

    /**
     * 所选用户的id
     */
    @NotNull(message = "用户id不能为空")
    private Long userId;

    /**
     * 所选用户登陆名称
     */
    @NotBlank(message = "选用户登录名称不能为空")
    private String userName;

    /**
     * 客服编号
     */
    @NotBlank(message = "客服编号不能为空")
    private String code;

    /**
     * 客服名称
     */
    @NotBlank(message = "客服名称不能为空")
    private String name;

    /**
     * 客服电话
     */
    @NotBlank(message = "客服电话不能为空")
    private String phone;

    /**
     * 车场ids
     */
    @NotEmpty(message = "车场信息不能为空")
    private List<Long> parkIds;
}
