package com.icetech.cloudcenter.domain.charge.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 白天夜间计费
 *
 * @author fangct
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class DayNightChargeCfgDTO implements Serializable {
    /**
     * 白天计费方式 （1:按次计费，2:按时计费）
     */
    public Integer sBillmethodday;
    /**
     * 夜间计费方式 （1:按次计费，2:按时计费）
     */
    public Integer sBillmethodnight;
    /**
     * 免费时长（分钟）
     */
    public Integer sFreetime;
    /**
     * 是否使用一天最大收费限额（一天) （0：禁用，1：启用，默认0）
     */
    public Integer sDaynightmaxfeeusing;
    /**
     * 最高收费类型  1=单天单次最高收费 2=单天最高收费 3=24小时最高收费 4=单次最高收费
     */
    public Integer sMaxfeetype;
    /**
     * 单天最高收费金额元
     */
    public Float sDaynightmaxfee;
    /**
     * 单天最高收费金额元_大型车
     */
    public Float sDaynightmaxfee_big;
    /**
     * 白天开始计费时间分钟
     */
    public Integer sDaybegin;
    /**
     * 晚上开始计费时间分钟
     */
    public Integer sNightbegin;
    /**
     * 是否启用白天最大收费 （1:是，2:否，默认2）
     */
    public Integer sDaymaxfeeusing;
    /**
     * 白天最大收费金额元
     */
    public Float sDaymaxfee;
    /**
     * 白天最大收费金额元_大型车
     */
    public Float sDaymaxfee_big;
    /**
     * 是否启用夜间最大收费 （1:是，2:否，默认2）
     */
    public Integer sNightmaxfeeusing;
    /**
     * 夜间最大收费金额元
     */
    public Float sNightmaxfee;
    /**
     * 夜间最大收费金额元_大型车
     */
    public Float sNightmaxfee_big;
    /**
     * 白天按次计费
     */
    public OnceChargeCfgDTO sDay_OnceCharge;
    /**
     * 白天按时计费
     */
    public DyrationChargeCfgDTO sDay_DyrationCharge;
    /**
     * 夜间按次计费
     */
    public OnceChargeCfgDTO sNight_OnceCharge;
    /**
     * 夜间按时计费
     */
    public DyrationChargeCfgDTO sNight_DyrationCharge;

}
