package com.icetech.cloudcenter.domain.charge.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 计费规则
 *
 * @author fangct
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ChargeRuleCfgDTO implements Serializable {
    /**
     * 计费规则编号 时间+随机数小于16位
     */
    public String sBilltypecode;
    /**
     *  1：通用自然天计费，2：白天夜间计费，3:二十四小时计费
     */
    public Integer sBilltype;
    /**
     * 白天夜间计费规则
     */
    public DayNightChargeCfgDTO sDayNightCharge;
    /**
     * 24小时计费规则
     */
    public S24HoursChargeCfgDTO s24HoursCharge;
    /**
     * 通用自然天计费规则
     */
    public NaturalChargeCfgDTO sNaturalCharge;

}
