package com.icetech.cloudcenter.domain.charge.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 计费配置
 *
 * @author fangct
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ChargeConfigCfgDTO implements Serializable {
    /**
     * 计费精度 （0:分钟，1:秒 默认0）
     */
    public Integer sBill_precision;
    /**
     * 免费时长是否计入停车费用（1:是，2:否，默认2）
     */
    public Integer sFreetime_status;
    /**
     * 是否补时 （1:是，2:否 默认1）
      */
    public Integer sIs_filltime;
    /**
     * 超时计费起始时间（1:末次缴费时间，2:车辆入场时间，默认1）
     */
    public Integer sOvertime_bill_type;
    /**
     * 是否允许二次使用免费时长 （1:不允许，2:允许，默认1）
     */
    public Integer sIsallowfreetmonce;
    /**
     * 收费是否抹零头（1:是，2:否，默认1）
     */
    public Integer sIsnotgetsmallchange;
    /**
     * 支持多车位管理超时处理规则（1:B车计费结束时间按A车出场时间收费，2:B车计费结束时间按B车出场时间收费，默认1）
     */
    public Integer sSwitch_type;
    /**
     * 计费规则版本编号（详见版本信息表定义），默认0
     */
    public Integer sChargeVersionNum;
}
