package com.icetech.cloudcenter.domain;

import com.github.pagehelper.Page;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class PageResult<T> implements Serializable {
    protected Integer pageNo = 1;
    protected Integer pageNum = 1;
    protected Integer pageIndex = 1;
    protected Integer pageSize = 10;
    protected Integer totalPages = 0;
    protected Long totalCount = 0L;
    protected List<T> dataList;

    public PageResult(Page<T> page) {
        fromPage(page, page.getResult());
    }

    public PageResult(Page<?> page, List<T> dataList) {
        fromPage(page, dataList);
    }

    public void fromPage(Page<T> page) {
        fromPage(page, page.getResult());
    }

    public void fromPage(Page<?> page, List<T> dataList) {
        setPageNo(page.getPageNum());
        setPageNum(page.getPageNum());
        setPageIndex(page.getPageNum());
        setPageSize(page.getPageSize());
        setTotalPages(page.getPages());
        setTotalCount(page.getTotal());
        setDataList(dataList);
    }

    public static <T> PageResult<T> fromPages(Page<T> page) {
        return new PageResult<>(page);
    }

    public static <T> PageResult<T> fromPage(com.baomidou.mybatisplus.extension.plugins.pagination.Page<T> page) {
        PageResult<T> result = new PageResult<>();
        result.setPageNo((int) page.getCurrent());
        result.setPageNum((int) page.getCurrent());
        result.setPageIndex((int) page.getCurrent());
        result.setPageSize((int) page.getSize());
        result.setTotalPages((int) page.getPages());
        result.setTotalCount(page.getTotal());
        result.setDataList(page.getRecords());
        return result;
    }

    public com.icetech.common.domain.Page<T> toCommonPage() {
        return new com.icetech.common.domain.Page<>(totalCount, totalPages, dataList);
    }

    public static <T> PageResult<T> empty() {
        PageResult<T> result = new PageResult<>();
        result.setDataList(Collections.emptyList());
        return result;
    }
}
