package com.icetech.cloudcenter.api.user;

import com.icetech.user.domain.entity.user.SaasUser;
import com.icetech.cloudcenter.domain.response.SaasUserDto;
import com.icetech.user.domain.entity.user.MpUser;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.user.domain.vo.SaasCsUserVo;

import java.util.List;

/**
 * 用户service
 * @author wangzw
 */
public interface UserService {

    /**
     * 车场管家端的登录
     * @param userName
     * @param password
     * @return
     */
    ObjectResponse<SaasUserDto> carManagerLogin(String userName,String password);
    ObjectResponse<SaasUserDto> carManagerLogin(String userName,String password, String newPwd, Integer from);

    /**
     * 用户修改密码操作
     * @param userId
     * @param oldPwd
     * @param newPwd
     * @param updateOldPwd
     * @param updateNewPwd
     * @return
     */
    ObjectResponse updatePassWord(Integer userId,String oldPwd,String newPwd, String updateOldPwd, String updateNewPwd);
    /**
     * 用户重置密码
     * @param userId
     * @param newPwd
     * @return
     */
    ObjectResponse updatePassWord(Integer userId,String newPwd);
    /**
     * 获取用户详情信息
     * @param userId
     * @return
     */
    ObjectResponse<SaasUserDto> getUserDetail(Integer userId);

    /**
     * 公众号用户登录
     * @param mobile
     * @return
     */
    @Deprecated
    ObjectResponse<MpUser> mpLogin(String mobile,String openId);

    /**
     * 整合登录
     * @param mobile
     * @param openId
     * @param miniOpenId
     * @return
     */
    ObjectResponse<MpUser> mpLogin(String mobile,String openId,String miniOpenId);

    /**
     * 获取公众号用户绑定的车牌
     * @param mpUserId
     * @return
     */
    ObjectResponse<List<String>> getMpUserBindPlateNum(Integer mpUserId);

    /**
     * 添加绑定车牌
     * @param mpUserId
     * @param plateNum
     * @return
     */
    ObjectResponse addMpUserBindPlateNum(Integer mpUserId,String plateNum);

    /**
     * 删除绑定车牌
     */
    ObjectResponse deleteMpUserBindPlateNum(Integer mpUserId,String plateNum);

    /**
     * 根据账户名称获取用户
     * @param userName
     * @return
     */
    ObjectResponse<SaasUserDto> getUserByName(String userName);
    
    ObjectResponse<SaasUserDto> getUserByUserName(String userName);

    /**
     * 检查登录用户是否是车场管理员角色
     *
     * @param loginPortType
     * @param from
     * @return
     */
    boolean parkManagerLoginValidate(String loginPortType, Integer from);

    /**
     * 根据车牌号获取绑定微信公众号信息
     * @param plateNum
     * @return
     */
    ObjectResponse<MpUser> getMpUserByPlateNum(String plateNum);

    /**
     * seatNumber 查询用户信息
     * @param seatNumber    seatNumber
     * @return SaasUser
     */
    ObjectResponse<SaasUser> getSaasUserBySeatNum(String seatNumber);
    
    /**
     * Description: 用户 id 批量查询用户信息
     * Version1.0 2023-07-18 by wgy 创建
     * 
     * @param userIds   用户 id集合
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.cloudcenter.domain.entity.user.SaasUser>>       
     */
    ObjectResponse<List<SaasUser>> getSaasUserByIds(List<Long> userIds);
    
    /**
     * Description: 查询客服用户
     * Version1.0 2023-11-29 by wgy 创建
     * 
     * @param userIds   用户 id
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.user.domain.entity.user.SaasUser>>       
     */
    ObjectResponse<List<SaasUser>> getSaasCsUserByIds(List<Long> userIds);
    
    /**
     * Description: 通过车场查询工单客服
     * Version1.0 2023-11-29 by wgy 创建
     * 
     * @param parkCode            车场 code
     * @return com.icetech.common.domain.response.ObjectResponse<java.util.List<com.icetech.user.domain.vo.SaasCsUserVo>>       
     */
    ObjectResponse<List<SaasCsUserVo>> getCsUserByPark(String parkCode);

    /**
     * 海大登录(定制化)
     *
     * @param userName
     * @param password
     * @param from
     * @return
     */
    ObjectResponse<SaasUserDto> haiDaCarManagerLogin(String userName,String password, Integer from);
}
