package com.icetech.cloudcenter.api.third;

import com.icetech.cloudcenter.domain.request.NotifyRequest;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;

/**
 * 对外暴露的dubbo 接口
 * @author wangzw
 */
public interface SendInfoService {
    /**
     * 通知成功
     * @return
     */
    ObjectResponse notifySuccess(Integer serviceType,Integer serviceId);

    /**
     * 异步通知下发结果
     * @param notifyRequest
     * @return
     */
    ObjectResponse notify(NotifyRequest notifyRequest);

    /**
     * 通知成功
     * @param serviceType
     * @param serviceId
     * @param targetService
     * @return
     */
    ObjectResponse notifySuccess(Integer serviceType,Integer serviceId, Integer targetService);

    /**
     * 通知失败
     * @param serviceType
     * @param serviceId
     * @param cause
     * @return
     */
    ObjectResponse notifyFail(Integer serviceType,Integer serviceId, Integer targetService, String cause);

    /**
     * 新增
     */
    ObjectResponse<String> insert(SendInfo iceSendinfo);

    /**
     * 删除
     */
    ObjectResponse<String> delete(Long id);

    /**
     * 更新
     */
    ObjectResponse<String> update(SendInfo iceSendinfo);

    /**
     * Load查询
     */
    SendInfo load(int id);

    /**
     * 根据发送类型查询需要发送通知的订单信息
     */
    List<SendInfo> selectBySendTypeAndNum(int sendType, int maxNum);

    /**
     * 根据状态查询需要发送通知的订单信息
     */
    List<SendInfo> selectByStatusAndNum(String statusStr, int maxNum);
    List<SendInfo> selectDownSendList(String statusStr, int min, int maxNum);
    List<SendInfo> selectDownSendList(String statusStr, int maxNum);
    List<SendInfo> selectPushList(String statusStr, int maxNum);

    /**
     * 批量更新
     * @param collect
     * @return
     */
    int batchUpdate(List<SendInfo> collect);

    /**
     * 批量查询数据
     * @param sendInfos
     * @return
     */
    Boolean batchInsert(List<SendInfo> sendInfos);

    /**
     * 批量插入历史数据到历史表里
     */
    int batchInsertHistory(List<SendInfo> iceSendinfos);
    int insertHistory(SendInfo iceSendinfo);

    /**
     * 批量删除下发数据
     * @param ids
     * @return
     */
    int batchDelete(List<Long> ids);

    int updateSuccessByServiceIds(List<Long> ids, Integer serviceType);

    int updateSuccessByServiceIds(List<Long> ids, Integer serviceType, String remark);

    int updateFailByServiceIds(List<Long> ids, Integer serviceType, String remark);

    List<Long> selectFailListByIds(List<Long> ids);

    int updateFailByIds(List<Long> ids, Integer status, String remark);
}
