package com.icetech.cloudcenter.api.third;

import com.icetech.cloudcenter.domain.request.JinDiParkRequest;
import com.icetech.cloudcenter.domain.response.CheckOrderResponse;
import com.icetech.cloudcenter.domain.response.CheckStatusResponse;
import com.icetech.cloudcenter.domain.response.EnterRecordsResponse;
import com.icetech.cloudcenter.domain.response.ExitRecordsResponse;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface JinDiService {

    /**
     * 批量验证是否为月卡车
     * @param carNums
     * @param parkCode
     * @return
     */
    ObjectResponse<List<CheckStatusResponse>> batchCheckStatus(List<String> carNums, String parkCode);

    /**
     * 针对多车牌的月卡开卡
     * @param jinDiParkRequest
     * @return
     */
    ObjectResponse parkingCars(JinDiParkRequest jinDiParkRequest);

    /**
     * 取消停车
     */
    ObjectResponse cancelParking(String parkCode,String carNum);
    /**
     * 更新车辆信息
     */
    ObjectResponse updateCarsInfo(List<Map> carNums,String parkCode);

    /**
     * 根据车牌号 查询月卡车辆信息
     */
     ObjectResponse<CheckOrderResponse> checkStatus(String carNum, String parkCode);

    /**
     * 查询入场车辆信息
     */
    ObjectResponse<Page<EnterRecordsResponse>> getEnterList(Integer pageNum, Integer pageSize, String parkCode, Date startDate, Date endDate);
    /**
     * 查询出场车辆信息
     */
    ObjectResponse<Page<ExitRecordsResponse>> getExitList(Integer pageNum, Integer pageSize, String parkCode, Date startDate, Date endDate);
}
