package com.icetech.cloudcenter.api.report;

import com.icetech.report.domain.entity.CarTimeStatistics;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 停车时长日统计表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-10-10
 */
public interface CarTimeStatisticsService extends IBaseService<CarTimeStatistics> {

    /**
     * Description: 根据ID查询 停车时长日统计表对象信息 <br>
     * Version1.0 2021-10-10 by wanggang创建
     *
     * @param id 对象id
     * @return CarTimeStatistics
     */
    CarTimeStatistics getCarTimeStatisticsById (Long id);

    /**
     * Description: 新增  停车时长日统计表对象信息 <br>
     * Version1.0 2021-10-10 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addCarTimeStatistics (CarTimeStatistics entity);

    /**
     * Description: 修改 停车时长日统计表对象信息 <br>
     * Version1.0 2021-10-10 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyCarTimeStatistics (CarTimeStatistics entity);

    /**
     * Description: 删除  停车时长日统计表对象信息 <br>
     * Version1.0 2021-10-10 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeCarTimeStatisticsById (Long id);
}
